<?php
/**
 * Created by PhpStorm.
 * User: yilu-yj
 * Date: 2019/6/27
 * Time: 11:57
 */

namespace YiluTech\ShareCache;

use YiluTech\ShareCache\Commands\FlushCommand;
use YiluTech\ShareCache\Commands\RegisterCommand;
use YiluTech\ShareCache\Commands\ShowCommand;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class ShareCacheServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->app->singleton(ShareCacheServiceManager::class, function ($app) {
            return new ShareCacheServiceManager(config('sharecache', []));
        });
        $this->registerModelEvent();
    }

    public function register()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                RegisterCommand::class,
                FlushCommand::class,
                ShowCommand::class
            ]);
        }

        $this->registerRoute();

        $this->offerPublishing();
    }

    protected function registerModelEvent()
    {
        foreach (app(ShareCacheServiceManager::class)->getModels() as $model) {
            $model::created([ModelEventListener::class, 'created']);
            $model::updated([ModelEventListener::class, 'updated']);
            $model::deleted([ModelEventListener::class, 'deleted']);
        }
    }

    protected function registerRoute()
    {
        $defaultOptions = [
            'namespace' => '\YiluTech\ShareCache',
        ];
        $options = array_merge($defaultOptions, $this->app['config']['sharecache']['route_option'] ?? []);

        Route::group($options, function ($router) {
            Route::post('sharecache/put', 'ShareCacheController@put')->name('sharecache.put');
        });
    }

    protected function offerPublishing()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/sharecache.php' => config_path('sharecache.php'),
            ], 'sharecache-config');
        }
    }
}
