package gitlabauth

import (
	"errors"
	"fmt"
	"strings"

	"github.com/parnurzeal/gorequest"
	"gitlab.yilu.co/yilu-tech/gitlabauth/structs"
)

// var tokenMap map[string]structs.Projects
var tokenMap = make(map[string]structs.Projects)

// Authenticate is
func Authenticate(token string, url string) error {
	projectNameSlice := strings.Split(url, ".")

	projectMatchName := projectNameSlice[2] + "/"

	switch projectNameSlice[0] {
	case "gw":
		projectMatchName += "gateway"
	case "yimq":
		projectMatchName = "yimq"
	default:
		projectMatchName = projectMatchName + projectNameSlice[0] + "-service"
	}

	projects, err := getUserProjects(token, url)

	if err != nil {
		return err
	}

	hasMatched := matchProject(projectMatchName, projects)

	if !hasMatched {
		err = errors.New("无权访问")
		fmt.Println(err)
		return err
	}

	return nil
}

func getUserProjects(token string, url string) (projects structs.Projects, err error) {
	if tokenMap[token] != nil {
		projects = tokenMap[token]
	} else {
		request := gorequest.New()
		_, _, errs := request.Get("https://gitlab.yilu.co/api/v4/projects?simple=true&per_page=100").
			Set("PRIVATE-TOKEN", token).
			EndStruct(&projects)

		if errs != nil {
			fmt.Println(errs)
			err = errors.New("Get gitlab api error")
		}

		tokenMap[token] = projects
	}

	return
}

func matchProject(projectMatchName string, projects structs.Projects) bool {
	if projectMatchName == "yimq" {
		return true
	}

	for _, project := range projects {
		if projectMatchName == project.PathWithNamespace {
			return true
		}
	}
	return false
}
