<?php

namespace YiluTech\FileCenter\Mock;


use League\Flysystem\Filesystem;
use Illuminate\Filesystem\FilesystemAdapter;
use YiluTech\FileCenter\Adapter\Memory;
use YiluTech\FileCenter\Bridge\BridgeInterface;
use YiluTech\FileCenter\Bridge\LocalBridge;

class ServerMocker
{
    protected FilesystemAdapter $filesystem;

    public function __construct(array $buckets)
    {
        $this->boot();
        foreach ($buckets as &$bucket) {
            if (empty($bucket['disk'])) {
                $bucket['disk'] = 'memory';
            }
        }
        config()->set('filesystems.disks.memory', ['driver' => 'memory']);
        config()->set('filesystems.buckets', $buckets);
        $this->filesystem = app('filesystem')->disk('memory');
    }

    public function getBridge(): BridgeInterface
    {
        return new LocalBridge();
    }

    public function mockFile(string $path, string $contents)
    {
        $this->filesystem->put($path, $contents);
    }

    protected function boot()
    {
        app('filesystem')->extend('memory', function ($config) {
            return new Filesystem(new Memory());
        });
    }
}
