<?php

namespace YiluTech\FileCenter\Http\Rules;

use Illuminate\Contracts\Validation\Rule;
use YiluTech\FileCenter\Facade\FileCenter;

class FileExists implements Rule
{
    protected array $notExists = [];

    protected $bucket;

    public function __construct($bucket = null)
    {
        $this->bucket = $bucket;
    }

    /**
     * @param string                           $attribute
     * @param                                  $value
     * @param array                            $parameters
     * @param \Illuminate\Validation\Validator $validator
     * @return bool
     */
    public function validate($attribute, $value, $parameters, $validator): bool
    {
        if (isset($parameters[0])) {
            $this->bucket = $parameters[0];
        }
        return $this->passes($attribute, $value);
    }

    public function passes($attribute, $value)
    {
        if (empty($value)) {
            return true;
        }
        $bucket = FileCenter::bucket($this->bucket);
        if (is_array($value)) {
            $this->notExists = array_diff($value, $bucket->filter($value));
            return empty($this->notExists);
        } else {
            return $bucket->exists($value);
        }
    }

    public function message()
    {
        if (empty($this->notExists)) {
            return 'The :attribute is invalided.';
        }
        return sprintf('The :attribute include file(%s) is invalided.', implode('; ', $this->notExists));
    }
}
