<?php

namespace YiluTech\FileCenter\Http\Controllers;

use Illuminate\Http\Request;
use YiluTech\FileCenter\Server;

class FileController
{
    public function call(Request $request)
    {
        app('validator')->make($request->input(), [
            'bucket' => 'required|string|max:16',
            'action' => 'required|string|max:16',
            'prefix' => 'nullable|string|max:64',
            'params' => 'array'
        ])->validate();
        try {
            return [
                'data'    => call_user_func_array([
                    new Server($request->input('bucket'), $request->input('prefix')),
                    $request->input('action'),
                ], $request->input('params', [])),
                'errcode' => 0
            ];
        } catch (\Exception $exception) {
            return ['errmsg' => $exception->getMessage(), 'errcode' => -1];
        }
    }
}
