<?php

namespace YiluTech\FileCenter;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;
use YiluTech\FileCenter\Bridge\BridgeInterface;
use YiluTech\FileCenter\Bridge\HttpBridge;
use YiluTech\FileCenter\Http\Rules\FileExists;

class FileClientServiceProvider extends ServiceProvider
{
    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function register()
    {
        $this->registerConnectBridge();
        $this->app->singleton(ClientManager::class);
    }

    public function boot()
    {
        Validator::extend('file_exists', FileExists::class);
    }

    public function registerConnectBridge()
    {
        $this->app->bind(BridgeInterface::class, function ($app) {
            return new HttpBridge(env('FILE_CENTER_URI_PREFIX'));
        });
    }
}
