<?php

namespace YiluTech\FileCenter\Facade;

use Illuminate\Support\Facades\Facade;
use YiluTech\FileCenter\ClientManager;

/**
 * Class FileCenter
 * @package YiluTech\FileCenter\Facade
 * @method static \YiluTech\FileCenter\Client mock(\YiluTech\FileCenter\Mock\ServerMocker $mocker)
 * @method static \YiluTech\FileCenter\Client bucket(string $bucket)
 * @method static \YiluTech\FileCenter\Client dir(string $dir, ...$params)
 * @method static string getBucket()
 * @method static string getUrl(string $path = '')
 * @method static bool exists(string $path)
 * @method static string move(string $from, string $to)
 * @method static array moveMany(array $from, string|string[] $to)
 * @method static string moveFromHtml(string $content, string $dir = '/', string $original = null, $tag = 'img')
 * @method static bool delete(string|string[] $path)
 * @method static mixed withDBTransition($callback)
 * @method static void beginBatch()
 * @method static void commit()
 * @method static void rollback()
 */
class FileCenter extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return ClientManager::class;
    }
}
