<?php


namespace YiluTech\FileCenter\Bridge;


use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use YiluTech\FileCenter\FileCenterException;

class HttpBridge implements BridgeInterface
{
    protected string $uri;

    protected array $cacheable = ['getUrl'];

    public function __construct($uri)
    {
        $this->uri = rtrim($uri, '/') . '/call';
    }

    public function call($bucket, $action, $params)
    {
        if (empty($params) && in_array($action, $this->cacheable)) {
            return $this->getFromCache($bucket, $action);
        }
        return $this->exec($bucket, $action, $params);
    }

    protected function exec($bucket, $action, $params)
    {
        $result = Http::post($this->uri, compact('action', 'bucket', 'params'))->throw()->json();

        if ($result['errcode']) throw new FileCenterException($result['errmsg']);
        return $result['data'];
    }

    protected function getFromCache($bucket, $action)
    {
        $key = "filecenter:$bucket:$action";
        $value = Cache::get($key);
        if (is_null($value)) {
            $value = $this->exec($bucket, $action, []);
            Cache::put($key, $value, 3600);
        }
        return $value;
    }
}
