<?php


namespace YiluTech\FileCenter\Adapter;


interface FileInterface
{
    public function getType(): string;

    public function getFileName(): string;

    public function getFilePath(): string;

    public function getSize(): int;

    public function getTimestamp(): int;

    public function rename(string $name);

    public function setVisibility($visibility);

    public function getVisibility();

    public function attach(Dir $target);

    public function detach();

    public function getContent();

    public function getStream();

    public function writeContent(string $contents);

    public function writeStream($stream);

    public function updateContent(string $contents);

    public function updateStream($stream);
}
