<?php

namespace YiluTech\FileCenter\Adapter;

class File extends BaseFileAbstract implements FileInterface
{
    protected int $maxMemorySize;

    protected $fp;

    protected int $size = 0;

    public function __construct(string $name, $maxMemorySize = 8 * 1024 * 1024)
    {
        parent::__construct($name);
        $this->maxMemorySize = $maxMemorySize;
        $this->fp = fopen("php://temp/maxmemory:$maxMemorySize", 'r+');
    }

    public function __destruct()
    {
        fclose($this->fp);
    }

    public function getType(): string
    {
        return 'file';
    }

    public function getSize(): int
    {
        return $this->size;
    }

    public function getMaxMemorySize(): int
    {
        return $this->maxMemorySize;
    }

    public function getContent(): string
    {
        if ($this->size) {
            rewind($this->fp);
            return fread($this->fp, $this->size);
        }
        return '';
    }

    public function getStream()
    {
        return $this->fp;
    }

    public function writeContent(string $contents)
    {
        fseek($this->fp, $this->size);
        fwrite($this->fp, $contents);
        $this->size = ftell($this->fp);
        $this->updateLastModify();
    }

    public function writeStream($stream)
    {
        fseek($this->fp, $this->size);
        if (stream_copy_to_stream($stream, $this->fp)) {
            $this->size = ftell($this->fp);
            $this->updateLastModify();
        }
    }

    public function updateContent(string $contents)
    {
        rewind($this->fp);
        fwrite($this->fp, $contents);
        $this->size = ftell($this->fp);
        $this->updateLastModify();
    }

    public function updateStream($stream)
    {
        rewind($this->fp);
        if (stream_copy_to_stream($stream, $this->fp)) {
            $this->size = ftell($this->fp);
            $this->updateLastModify();
        }
    }
}
