<?php


namespace YiluTech\FileCenter\Adapter;

interface DirInterface
{
    public function getType(): string;

    public function getFileName(): string;

    public function getFilePath(): string;

    public function getSize(): int;

    public function getTimestamp(): int;

    public function rename(string $name);

    public function setVisibility($visibility);

    public function getVisibility();

    public function attach(Dir $target);

    public function detach();

    public function getFile(string $filename);

    public function addFile($file);

    public function removeFile($file);

    public function listContents(): array;
}
