<?php

namespace YiluTech\FileCenter\Adapter;

use League\Flysystem\FileExistsException;

class Dir extends BaseFileAbstract implements DirInterface
{
    protected array $children = [];

    public function getType(): string
    {
        return 'dir';
    }

    public function getSize(): int
    {
        return count($this->children);
    }

    public function getFile(string $filename)
    {
        if ($filename === '.') return $this;

        if ($filename === '..') return $this->target;

        return $this->children[$filename] ?? null;
    }

    public function addFile($file)
    {
        $filename = $file->getFileName();
        if (isset($this->children[$filename])) {
            throw new FileExistsException($this->children[$filename]->getFilePath());
        }
        $this->children[$filename] = $file;
        $this->updateLastModify();
    }

    public function removeFile($file)
    {
        unset($this->children[$file->getFileName()]);
        $this->updateLastModify();
    }

    public function listContents(): array
    {
        return array_values($this->children);
    }
}
